/****** Object:  StoredProcedure [dbo].[usp_Insert_Admission_Request]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Insert_Admission_Request]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Insert_Admission_Request]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		silvicap
-- Create date: 24.10.2012
-- Description:	Insert admission request.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Insert_Admission_Request] 
	@ID	INT OUTPUT,
	@DOMAIN_ID VARCHAR(50),
	@ORDERED_DATE DATETIME,
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@SIGNED_DATE DATETIME,
	@RELEASED_DATE DATETIME,
	@PROVIDER_UID UNIQUEIDENTIFIER,
	@SIGNED_BY_UID UNIQUEIDENTIFIER,	
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@HOSPITAL_LOCATION_UID UNIQUEIDENTIFIER,
	@ORDER_TEXT	VARCHAR(MAX),
	@WARD_UID UNIQUEIDENTIFIER,
	@IS_ACTIVE BIT,
	@FACILITY_LIST NVARCHAR(MAX)
AS
SET NOCOUNT ON

BEGIN

	SELECT @ID = ID FROM ADMISSION_REQ WHERE IEN = @IEN AND VISTA_SITE_UID = @VISTA_SITE_UID

	IF (@ID IS NULL)
		BEGIN
			INSERT INTO ADMISSION_REQ
				(DOMAIN_ID,
				IEN,
				PATIENT_UID,
				ORDERED_DATE,
				IS_ACTIVE,
				SIGNED_BY_UID, 
				SIGNED_DATE, 
				RELEASED_DATE, 
				PROVIDER_UID, 
				VISTA_SITE_UID,
				HOSPITAL_LOCATION_UID,
				WARD_UID,
				ORDER_TEXT)
			VALUES
				(@DOMAIN_ID,
				@IEN,
				@PATIENT_UID,
				@ORDERED_DATE,
				@IS_ACTIVE,
				@SIGNED_BY_UID,
				@SIGNED_DATE,
				@RELEASED_DATE,
				@PROVIDER_UID,
				@VISTA_SITE_UID,
				@HOSPITAL_LOCATION_UID,
				@WARD_UID,
				@ORDER_TEXT)
	
			SET @ID = IDENT_CURRENT('dbo.ADMISSION_REQ')
	
			INSERT INTO ORDER_FACILITY (ORDER_ID, FACILITY_UID, ORDER_TYPE)
			SELECT @ID, S.VALUE, 'ADM'
			FROM dbo.fn_Split(@FACILITY_LIST, ',') AS S
		END
	
END
GO
